###############################################################################
#
#    SDK.MAK -- Make file for PLX 9050SDK Enumerator
#
#    Copyright (C) 1995 by Walter Oney
#    All rights reserved
#
#    Use with C9 (32-bit) and MASM 6.11 from DDK
#
###############################################################################

all: sdk.vxd

.asm.obj:
   ml -coff -DBLD_COFF -DIS_32 -W2 -Zd -c -Cx -DMASM6 -Zi -DDEBUG $*.asm

.c.obj:
   cl -c -Gs -Zdpl -Od -D_X86_ -YX -W3 -DDEBLEVEL=1 -DBLD_COFF -DDEBUG -DIS_32 $*.c

.rc.res:
   c:\msvc\bin\rc -r $*.rc   # must use RC16 for this

sdk.res: version.h $*.rc

sdk.c: plxio.h

sdk.vxd : s_ctl.obj $*.obj $*.def $*.res
   link @<<
-machine:i386 -def:$*.def -out:$@
-debug -debugtype:map
-map:$*.map -vxd vxdwraps.clb -nodefaultlib
s_ctl.obj $*.obj
<<
   c:\siw95\msym $*
   adrc2vxd $*.vxd $*.res
   copy $*.vxd c:\windows\system\plxsdk.vxd
   copy $*.vxd plxsdk.vxd

clean:
   del s_ctl.obj
   del vc20.pch
   del sdk.obj
   del sdk.res
   del sdk.lib
   del sdk.exp
   del sdk.map
   del sdk.wsp
